<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function roles()
	{
		return $this->morphToMany('Role');
	}

	public function user_meta()
	{
		return $this->hasMany('UserMeta');
	}

	public function address()
	{
		return $this->hasMany('UserAddress');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

}