<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Warehouse extends Eloquent {

	protected $table = 'warehouses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function products()
	{
		return $this->hasMany('Product');
	}

	public function address()
	{
		return $this->hasMany('WarehousesAdderss');
	}

}