<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration {

	public function up()
	{
		Schema::create('contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('landlord_id')->unsigned();
			$table->bigInteger('tenant_id')->unsigned();
			$table->bigInteger('property_id')->unsigned();
			$table->bigInteger('unit_id')->unsigned();
			$table->bigInteger('trn')->unique();
			$table->bigInteger('doc_no');
			$table->double('rent_amount');
			$table->date('contract_start_date');
			$table->date('contract_end_date');
			$table->date('created_date');
			$table->enum('status', array('new', 'renew'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contracts');
	}
}