<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRentDetailsTable extends Migration {

	public function up()
	{
		Schema::create('rent_details', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned();
			$table->enum('particular', array('rent', 'security_deposit'));
			$table->double('sub_amount');
			$table->double('vat_percent');
			$table->double('vat_amount');
			$table->double('total_amount');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rent_details');
	}
}