<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('helpdesk_id')->references('id')->on('helpdesk')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('referrer_id')->references('id')->on('referrer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('practitioner_id')->references('id')->on('practitioner')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('urgency_id')->references('id')->on('urgency')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('consult_type_id')->references('id')->on('consult_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('employee1')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('employee2')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('inspect_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('group_report_id')->references('id')->on('group_report')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('substance_translations', function(Blueprint $table) {
			$table->foreign('substance_id')->references('id')->on('substance')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('status_translations', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('report_substance', function(Blueprint $table) {
			$table->foreign('report_id')->references('id')->on('reports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('report_substance', function(Blueprint $table) {
			$table->foreign('substance_id')->references('id')->on('substance')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consult_type_translation', function(Blueprint $table) {
			$table->foreign('consult_id')->references('id')->on('consult_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('urgency_translations', function(Blueprint $table) {
			$table->foreign('urgency_id')->references('id')->on('urgency')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transportation_translation', function(Blueprint $table) {
			$table->foreign('transportation_id')->references('id')->on('transportation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('caretaker_translation', function(Blueprint $table) {
			$table->foreign('caretaker_id')->references('id')->on('caretaker')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('policy_triage_translations', function(Blueprint $table) {
			$table->foreign('policy_triage_id')->references('id')->on('policy_triage')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_helpdesk_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_referrer_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_client_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_practitioner_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_urgency_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_status_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_consult_type_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_employee1_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_employee2_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_inspect_user_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_group_report_id_foreign');
		});
		Schema::table('substance_translations', function(Blueprint $table) {
			$table->dropForeign('substance_translations_substance_id_foreign');
		});
		Schema::table('status_translations', function(Blueprint $table) {
			$table->dropForeign('status_translations_status_id_foreign');
		});
		Schema::table('report_substance', function(Blueprint $table) {
			$table->dropForeign('report_substance_report_id_foreign');
		});
		Schema::table('report_substance', function(Blueprint $table) {
			$table->dropForeign('report_substance_substance_id_foreign');
		});
		Schema::table('consult_type_translation', function(Blueprint $table) {
			$table->dropForeign('consult_type_translation_consult_id_foreign');
		});
		Schema::table('urgency_translations', function(Blueprint $table) {
			$table->dropForeign('urgency_translations_urgency_id_foreign');
		});
		Schema::table('transportation_translation', function(Blueprint $table) {
			$table->dropForeign('transportation_translation_transportation_id_foreign');
		});
		Schema::table('caretaker_translation', function(Blueprint $table) {
			$table->dropForeign('caretaker_translation_caretaker_id_foreign');
		});
		Schema::table('policy_triage_translations', function(Blueprint $table) {
			$table->dropForeign('policy_triage_translations_policy_triage_id_foreign');
		});
	}
}