<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMaitenanceOrdersTable extends Migration {

	public function up()
	{
		Schema::create('maitenance_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('building_id')->unsigned()->nullable();
			$table->integer('maintenance_type_id')->unsigned()->nullable();
			$table->integer('worker_id')->unsigned()->nullable();
			$table->text('description');
			$table->boolean('seen');
			$table->string('invoice', 255)->nullable();
			$table->enum('status', array('pending', 'accepted', 'canceled', 'closed'));
		});
	}

	public function down()
	{
		Schema::drop('maitenance_orders');
	}
}