<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRentalsTable extends Migration {

	public function up()
	{
		Schema::create('rentals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('building_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->date('start');
			$table->date('end');
			$table->date('pay_date');
			$table->integer('period_id')->unsigned()->nullable();
			$table->string('ref_code', 255);
			$table->double('price', 0,0);
			$table->string('electric_invoice', 255);
			$table->string('contract', 255);
			$table->boolean('electric_use');
			$table->boolean('water_use');
		});
	}

	public function down()
	{
		Schema::drop('rentals');
	}
}