<?php

namespace App\Models;

class DonationRequest extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('name', 'hospital_address', 'phone', 'city_id', 'hospital_name', 'blood_type_id', 'age', 'bags_num', 'details', 'client_id', 'latitude', 'longitude');

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function bloodType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

}