<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponTable extends Migration {

	public function up()
	{
		Schema::create('coupon', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code', 100)->nullable();
			$table->integer('value')->nullable();
			$table->enum('type', array('fixed', 'percentage'))->nullable();
			$table->date('expire')->nullable();
			$table->integer('max_use')->nullable()->default('0');
			$table->integer('usage')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('coupon');
	}
}