<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('vendor_id')->nullable();
			$table->integer('service_id')->nullable();
			$table->integer('doctor_id')->nullable();
			$table->date('date')->nullable();
			$table->bigInteger('slot_id')->nullable();
			$table->text('address')->nullable();
			$table->string('status', 100)->nullable();
			$table->double('total')->nullable();
			$table->integer('quantity')->nullable();
			$table->double('price')->nullable();
			$table->double('tax')->nullable();
			$table->string('payment_method')->nullable();
			$table->integer('coupon_id')->nullable();
			$table->double('discount')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}