<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientTable extends Migration {

	public function up()
	{
		Schema::create('patient', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('nationality_id')->nullable();
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('phone')->nullable();
			$table->string('iqama_number')->nullable();
			$table->integer('relationship_id')->nullable();
			$table->date('dob')->nullable();
			$table->bigInteger('age')->nullable();
			$table->string('gender')->nullable();
			$table->integer('insurance_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('patient');
	}
}