<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketTable extends Migration {

	public function up()
	{
		Schema::create('ticket', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_en')->nullable();
			$table->string('title_ar')->nullable();
			$table->text('message_en')->nullable();
			$table->text('message_ar')->nullable();
			$table->string('status', 100)->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ticket');
	}
}