<?php

namespace Plenty\Modules\Order\Models;

class OrderPositionAmount extends Eloquent {

	protected $table = 'plenty_order_position_amount';
	public $timestamps = true;
	protected $guarded = array('id');
	protected $fillable = array('orderPositionId', 'isSystemCurrency', 'countryVatId', 'vatId', 'currency', 'exchangeRatio', 'vatAmount', 'priceOriginalGross', 'priceGross', 'markup', 'rabate', 'isPercentel');
	protected $visible = array('id', 'orderPositionId', 'isSystemCurrency', 'countryVatId', 'vatId', 'currency', 'exchangeRatio', 'vatAmount', 'priceOriginalGross', 'priceGross', 'markup', 'rabate', 'isPercentel', 'createdAt', 'updatedAt');

	public function orderPosition()
	{
		return $this->belongsTo('OrderPosition', 'orderId');
	}

}