<?php

namespace Plenty\Modules\Order\Models;

class OrderPositionDateOption extends Eloquent {

	protected $table = 'plenty_order_position_date_option';
	public $timestamps = true;
	protected $guarded = array('id');
	protected $fillable = array('orderPositionId', 'typeId');
	protected $visible = array('id', 'orderPositionId', 'typeId', 'date', 'updatedAt');

	public function type()
	{
		return $this->hasMany('OrderDateOptionType', 'id', 'typeId');
	}

	public function orderPositions()
	{
		return $this->belongsTo('OrderPosition', 'orderPositionId');
	}

}