<?php

namespace Plenty\Modules\Order\Models;

class OrderPositionType extends Eloquent {

	protected $table = 'plenty_order_position_type';
	public $timestamps = false;
	protected $guarded = array('id', 'nonErasable');
	protected $fillable = array('position');
	protected $visible = array('id', 'nonErasable', 'position');

	public function names()
	{
		return $this->hasMany('OrderPositionTypeName', 'typeId', 'id');
	}

	public function orderPositions()
	{
		return $this->hasMany('OrderPosition', 'typeId', 'id');
	}

}