<?php

namespace Plenty\Modules\Order\Models;

class OrderType extends Eloquent {

	protected $table = 'plenty_order_type';
	public $timestamps = false;
	protected $guarded = array('id', 'nonErasable');
	protected $fillable = array('position');
	protected $visible = array('id', 'nonErasable', 'position');

	public function names()
	{
		return $this->hasMany('OrderTypeName', 'typeId', 'id');
	}

	public function orders()
	{
		return $this->hasMany('Order', 'typeId', 'id');
	}

}