<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateThirdsTable extends Migration {

	public function up()
	{
		Schema::create('thirds', function(Blueprint $table) {
			$table->increments('id');
			$table->string('dignity', 255)->nullable()->index()->default('NULL');
			$table->string('entity_name', 255)->nullable()->index()->default('NULL');
			$table->integer('person_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('thirds');
	}
}