<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('applicants', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->foreign('title_id')->references('id')->on('titles')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->foreign('statute_id')->references('id')->on('statutes')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('title_applicants', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('title_applicants', function(Blueprint $table) {
			$table->foreign('title_id')->references('id')->on('titles')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('thirds', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('candidacies', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidacies', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidacies', function(Blueprint $table) {
			$table->foreign('third_id')->references('id')->on('thirds')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('candidacies', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('agents')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('jury_candidacies', function(Blueprint $table) {
			$table->foreign('jury_id')->references('id')->on('jurys')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('jury_candidacies', function(Blueprint $table) {
			$table->foreign('candidacy_id')->references('id')->on('candidacies')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('candidacy_id')->references('id')->on('candidacies')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidacy_services', function(Blueprint $table) {
			$table->foreign('candidacy_id')->references('id')->on('candidacies')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('candidacy_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('response_candidacy', function(Blueprint $table) {
			$table->foreign('candidacy_id')->references('id')->on('candidacies')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('response_candidacy', function(Blueprint $table) {
			$table->foreign('response_id')->references('id')->on('responses')
						->onDelete('set null')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('applicants', function(Blueprint $table) {
			$table->dropForeign('applicants_person_id_foreign');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->dropForeign('applicants_job_id_foreign');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->dropForeign('applicants_title_id_foreign');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->dropForeign('applicants_statute_id_foreign');
		});
		Schema::table('title_applicants', function(Blueprint $table) {
			$table->dropForeign('title_applicants_applicant_id_foreign');
		});
		Schema::table('title_applicants', function(Blueprint $table) {
			$table->dropForeign('title_applicants_title_id_foreign');
		});
		Schema::table('thirds', function(Blueprint $table) {
			$table->dropForeign('thirds_person_id_foreign');
		});
		Schema::table('candidacies', function(Blueprint $table) {
			$table->dropForeign('candidacies_offer_id_foreign');
		});
		Schema::table('candidacies', function(Blueprint $table) {
			$table->dropForeign('candidacies_applicant_id_foreign');
		});
		Schema::table('candidacies', function(Blueprint $table) {
			$table->dropForeign('candidacies_third_id_foreign');
		});
		Schema::table('candidacies', function(Blueprint $table) {
			$table->dropForeign('candidacies_agent_id_foreign');
		});
		Schema::table('jury_candidacies', function(Blueprint $table) {
			$table->dropForeign('jury_candidacies_jury_id_foreign');
		});
		Schema::table('jury_candidacies', function(Blueprint $table) {
			$table->dropForeign('jury_candidacies_candidacy_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_candidacy_id_foreign');
		});
		Schema::table('candidacy_services', function(Blueprint $table) {
			$table->dropForeign('candidacy_services_candidacy_id_foreign');
		});
		Schema::table('candidacy_services', function(Blueprint $table) {
			$table->dropForeign('candidacy_services_service_id_foreign');
		});
		Schema::table('response_candidacy', function(Blueprint $table) {
			$table->dropForeign('response_candidacy_candidacy_id_foreign');
		});
		Schema::table('response_candidacy', function(Blueprint $table) {
			$table->dropForeign('response_candidacy_response_id_foreign');
		});
	}
}