<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Applicant extends Model 
{

    protected $table = 'applicants';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function person()
    {
        return $this->hasOne('Person', 'person_id');
    }

    public function drinving_license()
    {
        return $this->hasOne('Title', 'param_id');
    }

    public function job()
    {
        return $this->hasOne('Job', 'job_id');
    }

    public function statute()
    {
        return $this->hasOne('Statute', 'statute_id');
    }

}