<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgentsTable extends Migration {

	public function up()
	{
		Schema::create('agents', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 128)->nullable()->index()->default('N');
			$table->string('firstname', 128)->nullable()->default('NULL');
			$table->string('email', 255)->nullable()->index();
			$table->string('password', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('agents');
	}
}