<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->index();
			$table->integer('brand_id')->unsigned();
			$table->text('description');
			$table->string('url', 512);
			$table->float('price');
			$table->float('weight');
			$table->string('upc', 255);
			$table->integer('submitted_by_user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}