<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateThreadsTable extends Migration {

	public function up()
	{
		Schema::create('threads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('source_id')->unsigned();
			$table->string('title', 766)->index();
			$table->text('content');
			$table->string('thread_identifier', 256);
			$table->datetime('date_posted');
			$table->integer('attempted');
			$table->integer('tweeted');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('threads');
	}
}