<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7ArtistTable extends Migration {

	public function up()
	{
		Schema::create('nh7_artist', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('cover_img')->nullable();
			$table->string('name');
			$table->boolean('is_active')->default(1);
			$table->string('real_name')->nullable();
			$table->string('nick_name')->nullable();
			$table->text('description')->nullable();
			$table->string('seo_title')->nullable();
			$table->text('seo_keywords')->nullable();
			$table->text('seo_description')->nullable();
			$table->string('facebook_url')->nullable();
			$table->string('twitter_url')->nullable();
			$table->string('youtube_url')->nullable();
			$table->string('instagram_url')->nullable();
			$table->string('soundcloud_url')->nullable();
			$table->string('bandcamp_url')->nullable();
			$table->string('website')->nullable();
			$table->string('slug')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_artist');
	}
}