<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7GalleryTable extends Migration {

	public function up()
	{
		Schema::create('nh7_gallery', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id')->unsigned();
			$table->string('avatar')->nullable();
			$table->boolean('is_active')->default(1);
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->string('media_type', 10)->default('Image');
			$table->text('url')->nullable();
			$table->integer('festival_id')->unsigned();
			$table->integer('sequence_no')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_gallery');
	}
}