<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('email');
			$table->string('country_code');
			$table->string('phone');
			$table->string('avatar');
			$table->tinyInteger('is_active')->default('0');
			$table->string('otp');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}