<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Investor extends Eloquent {

	protected $table = 'investors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function investorTransactions()
	{
		return $this->hasMany('InvestorTransaction');
	}

	public function data()
	{
		return $this->hasOne('InvestorData');
	}

}