<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Investor extends Model 
{

    protected $table = 'investors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function investorTransactions()
    {
        return $this->hasMany('InvestorTransaction');
    }

    public function data()
    {
        return $this->hasOne('InvestorData');
    }

}