<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orderdetails', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('designs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('designdetailimages', function(Blueprint $table) {
			$table->foreign('designdetail_id')->references('id')->on('designdetails')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->foreign('design_id')->references('id')->on('designs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->foreign('side_id')->references('id')->on('sides')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('designdetailtypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('designmocks', function(Blueprint $table) {
			$table->foreign('design_id')->references('id')->on('designs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('designmocks', function(Blueprint $table) {
			$table->foreign('side_id')->references('id')->on('sides')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('orderdetails', function(Blueprint $table) {
			$table->dropForeign('orderdetails_order_id_foreign');
		});
		Schema::table('designs', function(Blueprint $table) {
			$table->dropForeign('designs_user_id_foreign');
		});
		Schema::table('designdetailimages', function(Blueprint $table) {
			$table->dropForeign('designdetailimages_designdetail_id_foreign');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->dropForeign('designdetails_design_id_foreign');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->dropForeign('designdetails_side_id_foreign');
		});
		Schema::table('designdetails', function(Blueprint $table) {
			$table->dropForeign('designdetails_type_id_foreign');
		});
		Schema::table('designmocks', function(Blueprint $table) {
			$table->dropForeign('designmocks_design_id_foreign');
		});
		Schema::table('designmocks', function(Blueprint $table) {
			$table->dropForeign('designmocks_side_id_foreign');
		});
	}
}