<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFconditionsTable extends Migration {

	public function up()
	{
		Schema::create('fconditions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('fclient_id')->unsigned();
			$table->integer('age_from')->unsigned()->nullable();
			$table->integer('age_to')->unsigned()->nullable();
			$table->integer('height_from')->unsigned()->nullable();
			$table->integer('height_to');
			$table->integer('residence_id')->unsigned();
			$table->integer('nationality_id')->unsigned();
			$table->string('origin')->nullable();
			$table->string('tribe')->nullable();
			$table->enum('educational_level', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('work', array(''))->nullable();
			$table->enum('social_status', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('money_level', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('health_status', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('religion_level', array(''))->nullable();
			$table->enum('beauty', array(''))->nullable();
			$table->enum('skin_color', array(''))->nullable();
			$table->longText('detailed')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fconditions');
	}
}