<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('mclients', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationality')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mclients', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mclients', function(Blueprint $table) {
			$table->foreign('residence_id')->references('id')->on('residence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mconditions', function(Blueprint $table) {
			$table->foreign('mclient_id')->references('id')->on('mclients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mconditions', function(Blueprint $table) {
			$table->foreign('residence_id')->references('id')->on('residence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mconditions', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationality')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fclients', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationality')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fclients', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fclients', function(Blueprint $table) {
			$table->foreign('residence_id')->references('id')->on('residence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fconditions', function(Blueprint $table) {
			$table->foreign('fclient_id')->references('id')->on('fclients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fconditions', function(Blueprint $table) {
			$table->foreign('residence_id')->references('id')->on('residence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fconditions', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationality')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('mclient_id')->references('id')->on('mclients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('fclient_id')->references('id')->on('fclients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('add_requests', function(Blueprint $table) {
			$table->foreign('mclient_id')->references('id')->on('mclients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('add_requests', function(Blueprint $table) {
			$table->foreign('fclient_id')->references('id')->on('fclients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('mclients', function(Blueprint $table) {
			$table->dropForeign('mclients_nationality_id_foreign');
		});
		Schema::table('mclients', function(Blueprint $table) {
			$table->dropForeign('mclients_city_id_foreign');
		});
		Schema::table('mclients', function(Blueprint $table) {
			$table->dropForeign('mclients_residence_id_foreign');
		});
		Schema::table('mconditions', function(Blueprint $table) {
			$table->dropForeign('mconditions_mclient_id_foreign');
		});
		Schema::table('mconditions', function(Blueprint $table) {
			$table->dropForeign('mconditions_residence_id_foreign');
		});
		Schema::table('mconditions', function(Blueprint $table) {
			$table->dropForeign('mconditions_nationality_id_foreign');
		});
		Schema::table('fclients', function(Blueprint $table) {
			$table->dropForeign('fclients_nationality_id_foreign');
		});
		Schema::table('fclients', function(Blueprint $table) {
			$table->dropForeign('fclients_city_id_foreign');
		});
		Schema::table('fclients', function(Blueprint $table) {
			$table->dropForeign('fclients_residence_id_foreign');
		});
		Schema::table('fconditions', function(Blueprint $table) {
			$table->dropForeign('fconditions_fclient_id_foreign');
		});
		Schema::table('fconditions', function(Blueprint $table) {
			$table->dropForeign('fconditions_residence_id_foreign');
		});
		Schema::table('fconditions', function(Blueprint $table) {
			$table->dropForeign('fconditions_nationality_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_mclient_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_fclient_id_foreign');
		});
		Schema::table('add_requests', function(Blueprint $table) {
			$table->dropForeign('add_requests_mclient_id_foreign');
		});
		Schema::table('add_requests', function(Blueprint $table) {
			$table->dropForeign('add_requests_fclient_id_foreign');
		});
	}
}