<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_details', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('father_name', 100);
			$table->string('mother_name', 100);
			$table->string('spouse_name', 100);
			$table->enum('religion', array('islam', 'hinduism', 'buddhism', 'christianity'));
			$table->string('occupation', 100);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_details');
	}
}