<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_versions', function(Blueprint $table) {
			$table->foreign('products_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_versions', function(Blueprint $table) {
			$table->foreign('uoms_id')->references('id')->on('uoms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->foreign('products_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->foreign('categories_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('uom_rules', function(Blueprint $table) {
			$table->foreign('product_versions_id')->references('id')->on('product_versions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('uom_rules', function(Blueprint $table) {
			$table->foreign('uoms_id')->references('id')->on('uoms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('stockinhands', function(Blueprint $table) {
			$table->foreign('product_versions_id')->references('id')->on('product_versions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('income_items', function(Blueprint $table) {
			$table->foreign('financial_storages_id')->references('id')->on('financial_storages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('outcome_items', function(Blueprint $table) {
			$table->foreign('financial_storages_id')->references('id')->on('financial_storages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('buyers', function(Blueprint $table) {
			$table->foreign('payment_terms_id')->references('id')->on('payment_terms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_orders', function(Blueprint $table) {
			$table->foreign('buyers_id')->references('id')->on('buyers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_orders', function(Blueprint $table) {
			$table->foreign('payment_terms_id')->references('id')->on('payment_terms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_order_items', function(Blueprint $table) {
			$table->foreign('product_versions_id')->references('id')->on('product_versions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_order_items', function(Blueprint $table) {
			$table->foreign('warehouses_id')->references('id')->on('warehouses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_order_items', function(Blueprint $table) {
			$table->foreign('sales_orders_id')->references('id')->on('sales_orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_order_items', function(Blueprint $table) {
			$table->foreign('uom_id')->references('id')->on('uoms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_order_payments', function(Blueprint $table) {
			$table->foreign('sales_orders_id')->references('id')->on('sales_orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_order_payments', function(Blueprint $table) {
			$table->foreign('income_items_id')->references('id')->on('income_items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_return_orders', function(Blueprint $table) {
			$table->foreign('sales_orders_id')->references('id')->on('sales_orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_return_order_items', function(Blueprint $table) {
			$table->foreign('sales_return_orders_id')->references('id')->on('sales_return_orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_return_order_items', function(Blueprint $table) {
			$table->foreign('warehouses_id')->references('id')->on('warehouses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_return_order_items', function(Blueprint $table) {
			$table->foreign('product_versions_id')->references('id')->on('product_versions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_return_order_items', function(Blueprint $table) {
			$table->foreign('uoms_id')->references('id')->on('uoms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_return_payments', function(Blueprint $table) {
			$table->foreign('sales_return_orders_id')->references('id')->on('sales_return_orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sales_return_payments', function(Blueprint $table) {
			$table->foreign('outcome_items_id')->references('id')->on('outcome_items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('warehouse_products', function(Blueprint $table) {
			$table->foreign('product_versions_id')->references('id')->on('product_versions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_movement_orders', function(Blueprint $table) {
			$table->foreign('warehouses_id')->references('id')->on('warehouses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_movement_order_items', function(Blueprint $table) {
			$table->foreign('product_versions_id')->references('id')->on('product_versions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_movement_order_items', function(Blueprint $table) {
			$table->foreign('uoms_id')->references('id')->on('uoms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('product_versions', function(Blueprint $table) {
			$table->dropForeign('product_versions_products_id_foreign');
		});
		Schema::table('product_versions', function(Blueprint $table) {
			$table->dropForeign('product_versions_uoms_id_foreign');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->dropForeign('product_categories_products_id_foreign');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->dropForeign('product_categories_categories_id_foreign');
		});
		Schema::table('uom_rules', function(Blueprint $table) {
			$table->dropForeign('uom_rules_product_versions_id_foreign');
		});
		Schema::table('uom_rules', function(Blueprint $table) {
			$table->dropForeign('uom_rules_uoms_id_foreign');
		});
		Schema::table('stockinhands', function(Blueprint $table) {
			$table->dropForeign('stockinhands_product_versions_id_foreign');
		});
		Schema::table('income_items', function(Blueprint $table) {
			$table->dropForeign('income_items_financial_storages_id_foreign');
		});
		Schema::table('outcome_items', function(Blueprint $table) {
			$table->dropForeign('outcome_items_financial_storages_id_foreign');
		});
		Schema::table('buyers', function(Blueprint $table) {
			$table->dropForeign('buyers_payment_terms_id_foreign');
		});
		Schema::table('sales_orders', function(Blueprint $table) {
			$table->dropForeign('sales_orders_buyers_id_foreign');
		});
		Schema::table('sales_orders', function(Blueprint $table) {
			$table->dropForeign('sales_orders_payment_terms_id_foreign');
		});
		Schema::table('sales_order_items', function(Blueprint $table) {
			$table->dropForeign('sales_order_items_product_versions_id_foreign');
		});
		Schema::table('sales_order_items', function(Blueprint $table) {
			$table->dropForeign('sales_order_items_warehouses_id_foreign');
		});
		Schema::table('sales_order_items', function(Blueprint $table) {
			$table->dropForeign('sales_order_items_sales_orders_id_foreign');
		});
		Schema::table('sales_order_items', function(Blueprint $table) {
			$table->dropForeign('sales_order_items_uom_id_foreign');
		});
		Schema::table('sales_order_payments', function(Blueprint $table) {
			$table->dropForeign('sales_order_payments_sales_orders_id_foreign');
		});
		Schema::table('sales_order_payments', function(Blueprint $table) {
			$table->dropForeign('sales_order_payments_income_items_id_foreign');
		});
		Schema::table('sales_return_orders', function(Blueprint $table) {
			$table->dropForeign('sales_return_orders_sales_orders_id_foreign');
		});
		Schema::table('sales_return_order_items', function(Blueprint $table) {
			$table->dropForeign('sales_return_order_items_sales_return_orders_id_foreign');
		});
		Schema::table('sales_return_order_items', function(Blueprint $table) {
			$table->dropForeign('sales_return_order_items_warehouses_id_foreign');
		});
		Schema::table('sales_return_order_items', function(Blueprint $table) {
			$table->dropForeign('sales_return_order_items_product_versions_id_foreign');
		});
		Schema::table('sales_return_order_items', function(Blueprint $table) {
			$table->dropForeign('sales_return_order_items_uoms_id_foreign');
		});
		Schema::table('sales_return_payments', function(Blueprint $table) {
			$table->dropForeign('sales_return_payments_sales_return_orders_id_foreign');
		});
		Schema::table('sales_return_payments', function(Blueprint $table) {
			$table->dropForeign('sales_return_payments_outcome_items_id_foreign');
		});
		Schema::table('warehouse_products', function(Blueprint $table) {
			$table->dropForeign('warehouse_products_product_versions_id_foreign');
		});
		Schema::table('product_movement_orders', function(Blueprint $table) {
			$table->dropForeign('product_movement_orders_warehouses_id_foreign');
		});
		Schema::table('product_movement_order_items', function(Blueprint $table) {
			$table->dropForeign('product_movement_order_items_product_versions_id_foreign');
		});
		Schema::table('product_movement_order_items', function(Blueprint $table) {
			$table->dropForeign('product_movement_order_items_uoms_id_foreign');
		});
	}
}