<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('email')->unique()->nullable();
			$table->string('mobile')->unique()->nullable();
			$table->string('password')->nullable();
			$table->enum('type', array('client', 'saudi', 'foreign'))->nullable();
			$table->string('id_number')->nullable();
			$table->string('verification_code')->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->enum('first_login', array('true', 'false'))->nullable();
			$table->integer('nationality_id')->unsigned();
			$table->string('passport_number')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}