<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignRequestsTable extends Migration {

	public function up()
	{
		Schema::create('campaign_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('business_id')->unsigned();
			$table->integer('campaign_id')->unsigned();
			$table->integer('influencer_id')->unsigned();
			$table->string('requested_type')->nullable();
			$table->string('payment_details', 256)->nullable();
			$table->string('payment_status')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('campaign_requests');
	}
}