<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConnectionRequestsTable extends Migration {

	public function up()
	{
		Schema::create('connection_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('business_id')->unsigned();
			$table->integer('influencer_id')->unsigned();
			$table->string('requested_type')->nullable();
			$table->integer('requested_by_user_id')->unsigned();
			$table->string('status');
			$table->text('request_message')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('connection_requests');
	}
}