<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('business_id')->unsigned();
			$table->string('type', 64);
			$table->string('value', 64);
			$table->text('description');
			$table->integer('campaign_id')->unsigned()->nullable();
			$table->integer('influencer_id')->unsigned()->nullable();
			$table->json('data')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}