<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('rating')->nullable();
			$table->text('comment');
			$table->string('object_type');
			$table->integer('object_type_id')->unsigned();
			$table->datetime('rated_on');
			$table->integer('rated_by_user_id')->unsigned();
			$table->json('data')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}