<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCitiesTable extends Migration {

	public function up()
	{
		Schema::create('cities', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('country_id')->unsigned();
			$table->string('region', 5);
			$table->string('timezone');
			$table->string('latitude');
			$table->string('longitude');
			$table->string('name_en')->nullable();
			$table->string('name_ru')->nullable();
			$table->string('region_name_en')->nullable();
			$table->string('region_name_ru')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cities');
	}
}