<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('thread_id')->references('id')->on('threads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_message', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_message', function(Blueprint $table) {
			$table->foreign('message_id')->references('id')->on('messages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_thread_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_sender_id_foreign');
		});
		Schema::table('user_message', function(Blueprint $table) {
			$table->dropForeign('user_message_user_id_foreign');
		});
		Schema::table('user_message', function(Blueprint $table) {
			$table->dropForeign('user_message_message_id_foreign');
		});
	}
}