<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagosTable extends Migration {

	public function up()
	{
		Schema::create('pagos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('activacion_id')->unsigned();
			$table->integer('cantidad')->unsigned()->default('1');
			$table->float('precio_unitario');
			$table->float('total_a_pagar');
			$table->float('total_pagado');
			$table->bigInteger('estatus_pago');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pagos');
	}
}