<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cuenta extends Eloquent {

	protected $table = 'cuentas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cuenta', 'clabe');

	public function banco()
	{
		return $this->hasOne('App\Banco', 'banco_id');
	}

	public function tipoCuenta()
	{
		return $this->hasOne('Tipocuenta');
	}

}