<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Foto extends Eloquent {

	protected $table = 'fotos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function likers()
	{
		return $this->hasManyThrough('User', 'FotoLike');
	}

	public function tags()
	{
		return $this->hasManyThrough('Tag', 'FotoTag');
	}

	public function comments()
	{
		return $this->hasMany('Comment');
	}

}