<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShopsTable extends Migration {

	public function up()
	{
		Schema::create('shops', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->text('first_address');
			$table->text('second_address')->nullable();
			$table->text('description');
			$table->string('website')->nullable();
			$table->text('latitude')->nullable();
			$table->text('longitude')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shops');
	}
}