<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChatGroupMembersTable extends Migration {

	public function up()
	{
		Schema::create('chat_group_members', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('group_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->enum('role', array('admin', 'user'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('chat_group_members');
	}
}