<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRegisteredPropertiesTable extends Migration {

	public function up()
	{
		Schema::create('registered_properties', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('landlord_id');
			$table->string('reference');
			$table->string('address_1');
			$table->string('address_2');
			$table->string('address_3')->nullable();
			$table->string('town_city');
			$table->string('postcode');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('registered_properties');
	}
}