<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriverUsersTable extends Migration {

	public function up()
	{
		Schema::create('driver_users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 250);
			$table->string('country_code', 150)->nullable();
			$table->string('mobile', 150)->nullable();
			$table->string('email', 250)->nullable();
			$table->string('image', 250)->nullable();
			$table->string('grade', 250)->nullable();
			$table->string('balance', 250)->nullable();
			$table->enum('is_active', array('0', '1'));
			$table->string('remember_token', 250)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('driver_users');
	}
}