<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserPlanTable extends Migration {

	public function up()
	{
		Schema::create('user_plan', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('plan_id')->unsigned();
			$table->integer('is_active')->default('0');
			$table->date('purchased_date');
			$table->datetime('activated_date')->nullable();
			$table->datetime('expire_on')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_plan');
	}
}