<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabProductTable extends Migration {

	public function up()
	{
		Schema::create('tabProduct', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->string('status', 10)->default('Active');
			$table->integer('brand_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->text('description')->nullable();
			$table->string('technical_drawing')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
			$table->text('features')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tabProduct');
	}
}