<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookApprovalHistoryTable extends Migration {

	public function up()
	{
		Schema::create('book_approval_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('book_id')->unsigned()->index();
			$table->integer('changed_by')->unsigned();
			$table->enum('old_status', array(''));
			$table->enum('new_status', array(''));
			$table->text('feedback')->nullable();
			$table->timestamp('changed_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('book_approval_history');
	}
}