<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBooksTable extends Migration {

	public function up()
	{
		Schema::create('books', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('vendor_id')->unsigned()->index();
			$table->string('title')->index();
			$table->string('author_name');
			$table->boolean('is_emerging_author')->default(1);
			$table->text('description');
			$table->string('language');
			$table->integer('publication_year');
			$table->integer('page_count')->nullable();
			$table->enum('status', array(''pending'', ''approved'', ''rejected'', ''suspended''));
			$table->boolean('is_active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('books');
	}
}